
#include "..\config.h"
#include "string.h"
#include "userDataProcess.h"

// Delay ms
// input: 0~65535 
void delayUs(INT16U us) {
    INT16U i=0;
	INT16U j=0;
    for(i=0; i<=us; i++) {
	    for(j=0; j<=16; j++);
	}
}

// Delay us
// input: 0~65535 
void delayMs(INT16U ms) {
    INT16U i=0;
    for(i=0; i<=ms; i++) {
	    delayUs(1000);
	}
}

// Initialize Key1 ~ Key4 PIN as input
void keyInit(void) {
    FIO2DIR &= ~KEY1;        // Set P2.10(KEY1) as input
	FIO2DIR &= ~KEY2;        // Set P2.11(KEY2) as input
    FIO2DIR &= ~KEY3;        // Set P2.12(KEY3) as input
    FIO2DIR &= ~KEY4;        // Set P2.13(KEY4) as input
}

// Set DB7~DB0 PIN as input or ourput
// direction=1 -> input   direction=0(or any other value non-1) -> output;   
void lcdDdataPinsDirectionSet(INT8U direction) {
    if(direction==1) {
		FIO0DIR2 = 0x00;      // Set P0.23~P0.16 as input
	}
	else {
		FIO0DIR2 = 0xFF;      // Set P0.23~P0.16 as output
	}
}

// Initialize LCD control PINs as output; RST, CD, RW, E;
void lcdPinInit(void) {
    FIO0DIR |= RST;                 // set P0.15(RST) as output
	FIO1DIR |= CD;                  // set P1.31(A0) as output
	FIO3DIR |= RW;                  // set P3.25(RW) as output
	FIO3DIR |= E;                   // set P3.26(E) as output

	lcdDdataPinsDirectionSet(0);    // set data pins as output
}

// Set RST level
// Input:   0->Low;  1->High
void setRST(INT8U RST_value) {
	if(RST_value == 0) {
		FIO0CLR = RST;	     // RST = 0
	}
	else {
		FIO0SET = RST;		 // RST = 1
	}
}  

// Set CD level
// Input:   0->Low;  1->High
void setCD(INT8U CD_value) {
	if(CD_value == 0) {
		FIO1CLR = CD;	     // CD = 0
	}
	else {
		FIO1SET = CD;		 // CD = 1
	}
}

// Set RW level
// Input:   0->Low;  1->High
void setRW(INT8U RW_value) {
	if(RW_value == 0) {
		FIO3CLR = RW;	     // RW = 0
	}
	else {
		FIO3SET = RW;		 // RW = 1
   }
}

// Set E level
// Input:   0->Low;  1->High
void setE(INT8U E_value) {
	if(E_value == 0) {
		FIO3CLR = E;	     // E = 0
	}
	else {
		FIO3SET = E;		 // E = 1
    }
}



// Write command
// Input:  Refer to Command Set	of Data Sheet
void writeComd(INT8U comd) {

    lcdDdataPinsDirectionSet(0);	      // DB7~DB0 as output
	
	setRW(0);  setCD(0);				  // Write instruction register

	FIO0PIN2 = comd;  // output command on P0.23~P0.16, as a 8bits bus
    delayUs(10);

	setE(1);   delayUs(20);
	setE(0);   delayUs(100);
}



// Wirte data,
// Input:  Refer to Data Sheet
void writeData(INT8U data) {
	
	lcdDdataPinsDirectionSet(0);	      // DB7~DB0 as output

	setRW(0);  setCD(1);				  // Write data register

	FIO0PIN2 = data;  // output data on P0.23~P0.16, as a 8bits bus
    delayUs(10);

	setE(1);   delayUs(5);
	setE(0);   delayUs(10);
}

// Initialize LCM controller IC, NT7603H-BDT01 or compatible (SPLC780D)
void lcdInit(void) {
    delayMs(20);

    writeComd(0x38);   delayUs(100);     // Function Set
	writeComd(0x38);   delayUs(100);     // Function Set
	writeComd(0x38);   delayUs(100);	 // Function Set

    writeComd(0x38);    delayUs(100);	// Function Set
	writeComd(0x08);    delayUs(100);	// Display ON/OFF control
	writeComd(0x01);    delayMs(10);	// Clear display
	writeComd(0x06);	delayUs(100);	// Entry mode set
	writeComd(0x0c);	delayUs(100);	// Display ON/OFF control
}

// Clean screen
void cleanScreen() {
    writeComd(0x01);    delayMs(10);	// Clean display
}

/****************** Display Position Address Map (Hex)************************
*          1  2  3  4  5  6  7  8  9  10 11 12 (column)
*   row1   80 81 82	83 84 85 86 87 88 89 8a 8b  
*	row2   c0 c1 c2	c3 c4 c5 c6 c7 c8 c9 ca cb  
******************************************************************************/
// Print a CHARACTER on specific position of LCD
// Input:   row     -> 1~2; 
//          column  -> 1~12;
//          ch      -> ASCII character 
void printCharacter(INT8U row, INT8U column, unsigned char ch) {
	
	if(((column>=1)&&(column<=12))&&((row>=1)&&(row<=2))) {	  // Print character
		if(row==1) {
		    switch(column) {
				case 1:  {writeComd(0x80);  writeData(ch); break;}
				case 2:  {writeComd(0x81);  writeData(ch); break;}
				case 3:  {writeComd(0x82);  writeData(ch); break;}
				case 4:  {writeComd(0x83);  writeData(ch); break;}
				case 5:  {writeComd(0x84);  writeData(ch); break;}
				case 6:  {writeComd(0x85);  writeData(ch); break;}
				case 7:  {writeComd(0x86);  writeData(ch); break;}
				case 8:  {writeComd(0x87);  writeData(ch); break;}
				case 9:  {writeComd(0x88);  writeData(ch); break;}
				case 10: {writeComd(0x89);  writeData(ch); break;}
				case 11: {writeComd(0x8a);  writeData(ch); break;}
				case 12: {writeComd(0x8b);  writeData(ch); break;}
				default: break;
		    }
		}
		else if(row==2) {
		    switch(column) {
				case 1:  {writeComd(0xc0);  writeData(ch); break;}
				case 2:  {writeComd(0xc1);  writeData(ch); break;}
				case 3:  {writeComd(0xc2);  writeData(ch); break;}
				case 4:  {writeComd(0xc3);  writeData(ch); break;}
				case 5:  {writeComd(0xc4);  writeData(ch); break;}
				case 6:  {writeComd(0xc5);  writeData(ch); break;}
				case 7:  {writeComd(0xc6);  writeData(ch); break;}
				case 8:  {writeComd(0xc7);  writeData(ch); break;}
				case 9:  {writeComd(0xc8);  writeData(ch); break;}
				case 10: {writeComd(0xc9);  writeData(ch); break;}
				case 11: {writeComd(0xca);  writeData(ch); break;}
				case 12: {writeComd(0xcb);  writeData(ch); break;}
				default: break;
		    }
		}
	}
}

// Print String from specific position of LCD on one line
// Input:   row     -> 1~2; 
//          column  -> 1~12;
//          ch      -> ASCII character 
void printString(INT8U row, INT8U column, const char *str) {
    INT8U i=0;
	INT8U columnEnd;

    columnEnd=column + strlen(str)-1;

	for(i=column; i<=columnEnd; i++) {
		printCharacter(row, i, str[i-column]);
	}
}